#include "CameraCBuffer.hlsli"
#include "SamplerStates.hlsli"

struct PSInput {
	float4 PositionViewportS : SV_Position;
	float2 TexCoords : TEXCOORD0;
};

Texture2D<float2> DepthAndCoCSizeTex : register(t0);

float4 main(PSInput input) : SV_TARGET
{
	// Sample the depth and convert to linear clip space Z
	float2 depthAndCoCSize = DepthAndCoCSizeTex.SampleLevel(LinearSampler, input.TexCoords, 0);
	float linearDepthClipS = depthAndCoCSize.r / (FarClip - NearClip);

	const float3 Red = float3(1, 0, 0);
	const float3 Green = float3(0, 1, 0);
	const float3 Blue = float3(0, 0, 1);

	float4 output = float4(0, 0, 0, 1);
	if(linearDepthClipS <= 0.5) {
		output.rgb = lerp(Red, Green, linearDepthClipS * 2);
	} else {
		output.rgb = lerp(Green, Blue, linearDepthClipS * 2 - 1);
	}

	return output;
}